#!/usr/bin/env python
# -*- coding: utf-8 -*-

import matplotlib
from matplotlib import pyplot as plt
import numpy as np
import seaborn as sbn

matplotlib.rcParams.update({'font.size': 16})
plt.figure(figsize=(8,4))

X = np.linspace(-5,5,100)
sgm = lambda x: 1/(1+np.exp(-x))
Y = [sgm(x) for x in X]
plt.plot(X,Y,linewidth=2,label='Density $\mathbb{P}(y=1|s_i=t)$')
plt.xlim(-5,5)

inc=0.50
Xb = np.arange(-5,5,inc)
height = lambda x : max(min(0.99, sgm(x+inc/2) - (0.1*np.random.uniform()-0.05)),0)
Yb = [height(x) for x in Xb]
plt.bar(Xb, Yb, fc=(1, 1, 1, 0.5), width=inc, linewidth=1)

plt.xlabel('Uncalibrated scores $s_i$, grouped into bins', fontsize=18)
plt.ylabel('Empirical frequency\nof $y=1$ in each bin', fontsize=16)
# plt.legend(loc='upper left', fontsize=12)

plt.annotate('An independent online\ncalibration algorithm\nis executed in each bin.', 
             xy=(-2,0.2), xytext=(-4.5,0.6), arrowprops=dict(arrowstyle="->", facecolor='black', connectionstyle="arc3,rad=.2"))

plt.tight_layout()

# plt.show()
plt.savefig('hist2.pdf')
